



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - Interaktive sider</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel4.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">3 <a name='afsn3'></a>Interaktive
sider</H1>
<DIV ID="Indholdsfortegnelse4">
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>3.1
  Parametre til sider  47</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.1.1
  Afl&aelig;se en parameter fra URLen  47</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.1.2
  Arbejde med parametrene  48</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>3.2
  HTML-formularer  49</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.2.1
  Et lidt st&oslash;rre eksempel  50</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.2.2
  Opgave  51</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.2.3
  Lave HTML og behandle input med samme side  52</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.2.4
  De almindelige typer af formularfelter  53</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.2.5
  Afl&aelig;se alle parametre i en formular  55</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.2.6
  Videre l&aelig;sning  56</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.2.7
  Opgaver  56</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>3.3
  Appendiks: Typer af formularfelter  57</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>3.4
  Test dig selv  58</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>3.5
  Resum&eacute;  58</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>3.6
  Avanceret  59</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.6.1
  Indkode data i en URL (URL-indkodning)  59</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.6.2
  Skjulte felter i formularer  60</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.6.3
  Bruge skjulte felter til at etablere et forl&oslash;b  61</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.6.4
  Skjule parametrene (POST-metoden)  61</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.6.5
  Cookier  62</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.6.6
  S&aelig;tte cookier  62</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.6.7
  Afl&aelig;se cookier  63</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>3.7
  Avanceret: HTTP-protokollen  65</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.7.1
  Eksempel p&aring; kommunikation  65</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.7.2
  Formulardata med GET-metoden  66</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.7.3
  Formulardata med POST-metoden  66</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.7.4
  Cookier  67</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.7.5
  &Oslash;velse  67</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.7.6
  Sende mere data til klienten l&oslash;bende  67</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.7.7
  Eksempel: Syvtabellen langsomt  68</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">3.7.8
  Eksempel: F&oslash;lge med i serverens logfil  68</FONT></FONT></P>
</DIV>



<P CLASS="kapiteloversigt-western">En grundig forst&aring;else af de
basale emner i dette kapitel foruds&aelig;ttes i resten af bogen.
Kapitlet foruds&aelig;tter <a href='kapitel2.jsp'>kapitel 2</a>, Grundelementer i JSP.</P>
<P CLASS="western" STYLE="">Vi har nu set
hvordan man laver dynamiske hjemmesider, men det bliver f&oslash;rst
rigtigt interessant, n&aring;r siderne bliver interaktive, d.v.s. at
de kan f&aring; input fra brugeren og reagere p&aring; det. 
</P>
<H2 CLASS="western">3.1 <a name='afsn3.1'></a>Parametre til sider</SPAN></H2>
<P CLASS="western">M&aring;ske har du undret dig over at nogle URLer
har et sp&oslash;rgsm&aring;lstegn efter dokumentnavnet, f.eks.:
http://minesider.dk/dokument.jsp<B>?id=1234</B> 
</P>
<P CLASS="western">Det, der st&aring;r efter sp&oslash;rgsm&aring;lstegnet,
kaldes parametre til siden. <BR>I eksemplet herover er der en
parameter med navnet &quot;id&quot; og v&aelig;rdien &quot;1234&quot;</P>
<P CLASS="western">Ligeledes med:
http://minesider.dk/dokument.jsp<B>?navn=Jacob </B><BR>Her er
parameteren &quot;navn&quot; med v&aelig;rdien &quot;Jacob&quot;
sendt sammen med foresp&oslash;rgslen.</P>
<P CLASS="western">Er der flere parametre bliver de adskilt med et
&amp;-tegn. Her er f.eks b&aring;de &quot;id&quot; og &quot;navn&quot;
sat: http://minesider.dk/dokument.jsp<B>?id=1234&amp;navn=Jacob</B></P>
<H3 CLASS="western">3.1.1 <a name='afsn3.1.1'></a>Afl&aelig;se en parameter fra URLen</H3>
<P CLASS="western">Parametrene i URLen kan afl&aelig;ses og bruges i
JSP-siden. &Oslash;nsker man f.eks at afl&aelig;se parameteren &quot;navn&quot;
skriver man:</P>
<PRE CLASS="kode-western">  String parameterv&aelig;rdi = request.getParameter(&quot;navn&quot;);</PRE><P CLASS="western">
Man kalder alts&aring; metoden request.getParameter() og angiver
navnet p&aring; parameteren, man &oslash;nsker at afl&aelig;se.</P>
<P CLASS="western">Her er et fuldt eksempel p&aring; en side, der
afl&aelig;ser parameteren &quot;navn&quot; (det vigtigste i fed):</P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Afl&aelig;se parameter&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;%
  String <B>parameterv&aelig;rdi = request.getParameter(&quot;navn&quot;)</B>;
  out.print( &quot;V&aelig;rdien af parameteren 'navn' er: &lt;br&gt;&quot; + <B>parameterv&aelig;rdi</B> );
%&gt;

&lt;hr&gt;

Pr&oslash;v at kalde denne side med parameteren 'navn', 
ved at putte f.eks. ?navn=Jacob for enden af URLen. &lt;br&gt;
Her er et &lt;a href=&quot;aflaese_parameter.jsp?navn=Jacob&quot;&gt;eksempel&lt;/a&gt;
&lt;/body&gt;<IMG SRC="bog4_html_6aceb4fe.png" NAME="Grafik62" ALIGN=RIGHT BORDER=0>
&lt;/html&gt;</PRE>





<H4 CLASS="western">&Oslash;velse</H4>
<P CLASS="western">Pr&oslash;v at k&oslash;re dette eksempel, hvor du
angiver forskellige parametre i URLen. Du kan ogs&aring; lege med
eksemplet ved at g&aring; ind p&aring; adressen: <BR>
<A CLASS="western" HREF="http://javabog.dk:8080/JSP/kode/kapitel_03/aflaese_parameter.jsp?navn=MitNavn">http://javabog.dk:8080/JSP/kode/kapitel_03/aflaese_parameter.jsp?navn=MitNavn</A></P>
<H3 CLASS="western">3.1.2 <a name='afsn3.1.2'></a>Arbejde med parametrene</H3>
<P CLASS="western">Det f&oslash;lgende eksempel fanger genkender
parametre, nemlig &quot;id&quot; og &quot;navn&quot;. 
</P>
<P CLASS="western">Parametrene gemmes f&oslash;rst i nogle interne
variabler (af typen String), hvorefter de bruges. 
</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog4_html_5f0ca64.png" NAME="Grafik67" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">F&oslash;rst unders&oslash;ges om parameteren
&quot;navn&quot; overhovedet er sat til noget (med en if-s&aelig;tning).
</P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Parametre2&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;%
  String <B><SPAN LANG="da-DK">navnParameter</SPAN> = request.getParameter(&quot;navn&quot;)</B>;
  String <B><SPAN LANG="da-DK">idParameter</SPAN> = request.getParameter(&quot;id&quot;)</B>;
  <B>if (navnParameter == null) {</B>
    %&gt;
      Angiv navn og ID, ved at putte f.eks ?navn=Jacob&amp;id=1234
      for enden af URLen.&lt;p&gt;
    &lt;%
  <B>} else {</B>
    %&gt;
      Hej k&aelig;re &lt;%= <B>navnParameter</B> %&gt;! Godt at h&oslash;re fra dig!&lt;p&gt;
    &lt;%
  <B>}</B>

  <B>if (idParameter == null) {</B>
    %&gt;
      Du angav ikke noget ID. Gyldige ID er fra 1 til 2000.
    &lt;%    
  <B>} else {</B>
    int <B>id = Integer.parseInt(idParameter)</B>;
    %&gt;
      Du angav et ID p&aring; &lt;%= id %&gt;.
    &lt;%
    if (id &lt;= 0) out.print(&quot;Det er for lille.&quot;);
    else if (id &gt;2000) out.print(&quot;Det er for stort.&quot;);
    else out.print(&quot;Det er et gyldigt ID.&quot;);
  <B>}</B>
%&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Tilf&oslash;jer brugeren nogle parametre til URLen svarer serveren
med:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog4_html_m539c3e85.png" NAME="Grafik68" ALIGN=BOTTOM BORDER=0></P>
<H2 CLASS="western">3.2 <a name='afsn3.2'></a>HTML-formularer</SPAN></H2>
<P CLASS="western">Herunder beskrives hvordan man opbygger en
formular, som brugeren udfylder, og hvordan brugerens data derefter
kan behandles af serveren.</P>
<P CLASS="western">En HTML-formular er en stump HTML-kode, der
indeholder et indtastningsfelt, afkrydsningsfelt eller lignende, som
brugeren har mulighed for at p&aring;virke. For eksempel:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog4_html_48a0e2b0.png" NAME="Grafik10" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">P&aring; billedet har brugeren udfyldt
indtastningsfeltet med navnet 'S&oslash;ren Bak'.</P>
<P CLASS="western">HTML-koden til at lave en formular er et
&lt;form&gt;-element med en r&aelig;kke &lt;input&gt;-elementer af
forskellig type (her blot et enkelt af typen &quot;text&quot;). 
</P>
<P CLASS="western">Ovenst&aring;ende kunne have HTML-koden:</P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Formular&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
  &lt;h3&gt;Hvad hedder du?&lt;/h3&gt;
<B>  &lt;form&gt;</B>
<B>    &lt;input type=&quot;text&quot; name=&quot;navn&quot;&gt;</B>
<B>  &lt;/form&gt;</B>
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Udfylder brugeren formularen og trykker retur vil netl&aelig;seren
anmode om den samme side igen, men denne gang er indholdet af
formularen tilf&oslash;jet som parametre til URLen:</P>

<P CLASS="western"><IMG SRC="bog4_html_m6bd1ba39.png" NAME="Grafik11" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT><BR><BR>
</P>
<P CLASS="western">L&aelig;g m&aelig;rke til, hvordan v&aelig;rdien
af parameteren bliver indkodet ('%F8' for '&oslash;' og et '+' for
mellemrum) i URLen af netl&aelig;seren. Den bliver automatisk
afkodet igen af webserveren n&aring;r den afl&aelig;ses fra
JSP-siden.</P>
<H3 CLASS="western">3.2.1 <a name='afsn3.2.1'></a>Et lidt st&oslash;rre eksempel</H3>
<P CLASS="western">Til &lt;form&gt;-koden kan man tilf&oslash;je en
action-attribut, der bestemmer hvilken side der skal anmodes om
(sammen med parametrene), n&aring;r brugeren indsender formularen
(ved at trykke retur). Skriver man ikke nogen<SPAN STYLE="font-weight: medium">
action-attribut i &lt;form&gt;-koden vil anmodningen blive sendt til
den samme side. </SPAN>
</P>
<P CLASS="western">Her er et eksempel med en action-attribut:</P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Formular der kalder parametre2&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
  Angiv navn og ID:&lt;br&gt;
<SPAN STYLE="font-weight: medium">  </SPAN><B>&lt;form action=&quot;parametre2.jsp&quot;&gt;</B>
<B>    </B>Navn: <B>&lt;input type=&quot;text&quot;   name=&quot;navn&quot;&gt;                </B>&lt;br&gt;
<B>    </B>ID:   <B>&lt;input type=&quot;text&quot;   name=&quot;id&quot;   value=&quot;1234&quot;&gt;   </B>&lt;br&gt;
<B>          &lt;input type=&quot;submit&quot; name=&quot;OK&quot;   value=&quot;Indsend&quot;&gt;</B>
<B>  &lt;/form&gt;</B>
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
L&aelig;g m&aelig;rke til, at et felt kan v&aelig;re udfyldt p&aring;
forh&aring;nd (value=&quot;1234&quot; i indtastningsfeltet med
name=&quot;id&quot;). Selvom en formular er udfyldt p&aring; forh&aring;nd
kan brugeren godt redigere i feltet og give det en anden v&aelig;rdi.</P>
<P CLASS="western"><IMG SRC="bog4_html_1116ecf1.png" NAME="Grafik69" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>Bem&aelig;rk
ogs&aring; hvordan input-felter med type=&quot;submit&quot; bliver
til knapper, som brugeren kan trykke p&aring; for at indsende (eng.:
submit) formularen (s&aring; kan brugeren trykke p&aring; knappen i
stedet for at trykke retur). 
</P>
<P CLASS="western">Som tekst der vises p&aring; <SPAN LANG="da-DK">knappen</SPAN>
bruges &lt;input&gt;-feltets v&aelig;rdi (her er value=&quot;Indsend&quot;).</P>
<P CLASS="western">N&aring;r brugeren trykker p&aring;
Indsend-knappen sendes han hen til siden parametre2.jsp (formularen
har jo action=&quot;parametre2.jsp&quot;):</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog4_html_26869cd8.png" NAME="Grafik70" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT><BR><BR>
</P>
<P CLASS="western">I HTML-koden var der 3 input-felter, med name=
hhv. &quot;navn&quot;, &quot;id&quot; og &quot;OK&quot;. Derfor
overf&oslash;res disse 3 parametre med deres v&aelig;rdier, som
navn=Jacob&amp;id=1234&amp;OK=Indsend, der er tilf&oslash;jet til
URLen i adresselinjen.</P>
<P CLASS="western">Den side, der indeholder formularen, beh&oslash;ver
egentlig ikke v&aelig;re en JSP-fil. Den beh&oslash;ver ikke engang
ligge p&aring; den samme webserver som den side, der modtager
<SPAN LANG="da-DK">formulardataene<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>.</SPAN></P>
<P CLASS="western">Ogs&aring; Indsend-knappen (der jo ogs&aring; er
et &lt;input&gt;-felt) har f&aring;et sin v&aelig;rdi overf&oslash;rt
som parameter (det kan v&aelig;re rart til at skelne, hvis der er
flere indsend-knapper i formularen).</P>

<H3 CLASS="western">3.2.2 <a name='afsn3.2.2'></a>Opgave</H3>
<OL>
  <LI><P CLASS="western"><IMG SRC="bog4_html_m3f83b9da.png" NAME="Grafik27" ALIGN=RIGHT HSPACE=4 BORDER=0>&AElig;ndr
  i eksemplet Syvtabellen i <a href='kapitel2.jsp#afsn2.2.1'>afsnit 2.2.1</a> til at afl&aelig;se
  <SPAN LANG="da-DK">parameteren</SPAN> &quot;tabel&quot;, der skal
  v&aelig;re et nummer, der angiver hvilken tabel der skal udskrives
  (s&aring;dan at man, ved at give parameteren tabel=9, f&aring;r
  <SPAN LANG="da-DK">udskrevet</SPAN> ni-tabellen<SPAN LANG="da-DK">,
  som vist til h&oslash;jre</SPAN>).</P>
  <LI><P CLASS="western">Lav en HTML-formular i JSP-siden, s&aring;
  brugeren kan indtaste hvilken tabel, hun &oslash;nsker at f&aring;
  vist.</P>
</OL>
<H4 CLASS="western">L&oslash;sning</H4>
<P CLASS="western">Her er et forslag til l&oslash;sning:</P>
<PRE CLASS="kode-western">&lt;<SPAN LANG="da-DK">html</SPAN>&gt;
&lt;head&gt;&lt;<SPAN LANG="da-DK">title</SPAN>&gt;L&oslash;sning: Tabel fra parameter&lt;/title&gt;&lt;/head&gt;
&lt;<SPAN LANG="da-DK">body</SPAN>&gt;
&lt;p&gt;
  Indtast hvilken tabel du &oslash;nsker at f&aring; vist:&lt;<SPAN LANG="da-DK">br</SPAN>&gt;
  &lt;form&gt;
    &lt;input <B>type=&quot;<SPAN LANG="da-DK">text</SPAN>&quot; </B><SPAN LANG="da-DK">name</SPAN>=&quot;tabel&quot; <SPAN LANG="da-DK">value</SPAN>=&quot;9&quot;&gt;
  &lt;/form&gt;

&lt;%
  <SPAN LANG="da-DK">String</SPAN> <SPAN LANG="da-DK">tabelStr</SPAN><B> = <SPAN LANG="da-DK">request.getParameter</SPAN>(&quot;tabel&quot;)</B>;
  <B><SPAN LANG="da-DK">if</SPAN> (tabelStr != <SPAN LANG="da-DK">null</SPAN>)</B>
<B>  {</B>
    <SPAN LANG="da-DK">int</SPAN> tabel<B> = <SPAN LANG="da-DK">Integer.parseInt</SPAN>(tabelStr)</B>;
    <SPAN LANG="da-DK">out.println</SPAN>(&quot;&lt;br&gt;Her er &quot;+tabel+&quot;-tabellen:&lt;br&gt;&quot;);

    for (int i=1; i&lt;=10; i++)
    {
      out.println(tabel+&quot; gange &quot;+<B>i+&quot; </B>er: &quot;+<B>tabel*i+&quot;</B>.&lt;br&gt;&quot;);
    } 
  }
%&gt;
&lt;/p&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE>
<H3 CLASS="western" STYLE="">3.2.3 <a name='afsn3.2.3'></a>Lave HTML
og behandle input med samme side</H3>
<P CLASS="western">Ofte vil det v&aelig;re den samme JSP-side, der
producerer formularen og som behandler brugerens indtastninger i
formularen. 
</P>
<P CLASS="western">Lad os for eksempel lave en side, der husker
v&aelig;rdierne i den gamle formular:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>husk_<SPAN LANG="da-DK">vaerdi.jsp</SPAN></I></FONT></P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Husk v&aelig;rdi&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;%
  String <B>navnet = request.getParameter(&quot;navn&quot;)</B>;

  if (navnet == null) {
    %&gt;
      Angiv navn:
<SPAN STYLE="font-weight: medium">      </SPAN><B>&lt;form&gt;</B>
<B>        &lt;input type=&quot;text&quot; name=&quot;navn&quot;&gt;</B>
<B>      &lt;/form&gt;</B>
    &lt;%
  } else {
    %&gt;
      Hej k&aelig;re &lt;%= navnet %&gt;! Godt at h&oslash;re fra dig!&lt;br&gt;
<SPAN STYLE="font-weight: medium">      </SPAN><B>&lt;form&gt;</B>
<B>        &lt;input type=&quot;text&quot; name=&quot;navn&quot; value=&quot;&lt;%= navnet %&gt;&quot;&gt;</B>
<B>      &lt;/form&gt;</B>
    &lt;%
  }
%&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE>
<P CLASS="western"><IMG SRC="bog4_html_m43346d6a.png" NAME="Grafik71" ALIGN=BOTTOM BORDER=0><IMG SRC="bog4_html_7a6908ce.png" NAME="Grafik72" ALIGN=RIGHT BORDER=0></P>
<P CLASS="western"> <BR><BR><BR><BR>
</P>


<P CLASS="western"><BR>Her er action-<SPAN LANG="da-DK">attributten</SPAN>
til &lt;form&gt; overfl&oslash;dig, da det er den samme side, der f&aring;r
input (den kunne dog s&aelig;ttes med &lt;form
action=&quot;husk_<SPAN LANG="da-DK">vaerdi.jsp</SPAN>&quot;&gt;).</P>
<H3 CLASS="western" STYLE="">3.2.4 <a name='afsn3.2.4'></a>De
almindelige typer af formularfelter</H3>
<P CLASS="western">Alle de almindelige slags formularfelter er
beskrevet i <a href='kapitel3.jsp#afsn3.3'>afsnit 3.3</a>, Appendiks: Typer af formularfelter. Her er en
HTML-side med dem. Sammenlign med billedet p&aring; n&aelig;ste side,
der viser hvordan det ser ud i en <SPAN LANG="da-DK">netl&aelig;ser
(Konqueror under Linux).</SPAN></P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Typer af formularfelter&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;h1&gt;Typer af formularfelter&lt;/h1&gt;
&lt;form action=&quot;parametre3.jsp&quot;&gt;

&lt;p&gt;Skriv dit navn (tekstfelt):
  <B>&lt;input type=&quot;text&quot; name=&quot;navn&quot; value=&quot;Jacob&quot; <SPAN LANG="da-DK">size</SPAN>=&quot;10&quot;&gt;</B>
   &lt;br&gt;og din kode (kodefelt):
  <B>&lt;input type=&quot;password&quot; name=&quot;kode&quot; value=&quot;<SPAN LANG="da-DK">abcdef</SPAN>&quot; size=&quot;10&quot;&gt;</B>
<B>  &lt;input type=&quot;<SPAN LANG="da-DK">hidden</SPAN>&quot; name=&quot;id&quot; value=&quot;1234&quot;&gt;</B>
&lt;/p&gt;

&lt;p&gt;Beskriv dig selv (tekstomr&aring;de): &lt;br&gt;
<B>  &lt;<SPAN LANG="da-DK">textarea</SPAN> name=&quot;beskrivelse&quot; <SPAN LANG="da-DK">rows</SPAN>=&quot;2&quot; <SPAN LANG="da-DK">cols</SPAN>=&quot;30&quot;&gt;</B><SPAN STYLE="font-weight: medium">Jeg taler esperanto</SPAN>
<B>  &lt;/textarea&gt;</B>
&lt;/p&gt;

&lt;p&gt;Hvad foretr&aelig;kker du at programmere i&lt;br&gt;(radioknapper):
<B>  &lt;input type=&quot;radio&quot; name=&quot;<SPAN LANG="da-DK">foretr</SPAN>_<SPAN LANG="da-DK">prg</SPAN>&quot; value=&quot;c&quot;&gt;</B>C
  <B>&lt;input type=&quot;radio&quot; name=&quot;foretr_prg&quot; value=&quot;<SPAN LANG="da-DK">cpp</SPAN>&quot;&gt;</B>C++
  <B>&lt;input type=&quot;radio&quot; name=&quot;foretr_prg&quot; value=&quot;<SPAN LANG="da-DK">java</SPAN>&quot; <SPAN LANG="da-DK">checked</SPAN>=&quot;checked&quot;&gt;</B><SPAN LANG="da-DK">Java</SPAN>
&lt;/p&gt;

&lt;p&gt;Hvad kan du programmere i&lt;br&gt;(afkrydsningsfelter):
  <B>&lt;input type=&quot;<SPAN LANG="da-DK">checkbox</SPAN>&quot; name=&quot;kan_prg&quot; value=&quot;c&quot;  checked=&quot;checked&quot;</B>&gt;C
  <B>&lt;input type=&quot;checkbox&quot; name=&quot;kan_prg&quot; value=&quot;cpp&quot;&gt;</B>C++
  <B>&lt;input type=&quot;checkbox&quot; name=&quot;kan_prg&quot; value=&quot;java&quot; checked=&quot;checked&quot;&gt;</B>Java
&lt;/p&gt;

&lt;p&gt;Hvilken ret foretr&aelig;kker du (valgliste): &lt;br&gt;
<B>  &lt;<SPAN LANG="da-DK">select</SPAN> name=&quot;foretr_spise&quot;&gt;</B>
    <B>&lt;option&gt;</B>Spaghetti med <SPAN LANG="da-DK">k&oslash;dsovs</SPAN><B>&lt;/option&gt;</B>
    <B>&lt;option <SPAN LANG="da-DK">selected</SPAN>=&quot;selected&quot;&gt;</B>Pizza<B>&lt;/option&gt;</B>
    <B>&lt;option&gt;</B>Ostefondue<B>&lt;/option&gt;</B>
    <B>&lt;option&gt;Rugbr&oslash;d&lt;/option&gt;</B>
<B>  &lt;/select&gt;</B>
&lt;/p&gt;

&lt;p&gt;Hvilke retter kan du spise (valgliste): &lt;br&gt;
<B>  &lt;select name=&quot;kan_spise&quot; size=&quot;3&quot; <SPAN LANG="da-DK">multiple</SPAN>=&quot;multiple&quot;&gt;</B>
<B>    &lt;option value=&quot;spa&quot; selected=&quot;selected&quot;&gt;</B>Spaghetti med k&oslash;dsovs<B>&lt;/option&gt;</B>
<B>    &lt;option value=&quot;<SPAN LANG="da-DK">piz</SPAN>&quot; selected=&quot;selected&quot;&gt;</B>Pizza<B>&lt;/option&gt;</B>
<B>    &lt;option value=&quot;ost&quot;&gt;</B>Ostefondue<B>&lt;/option&gt;</B>
    <B>&lt;option value=&quot;rug&quot; selected=&quot;selected&quot;&gt;Rugbr&oslash;d&lt;/option&gt;</B>
<B>  &lt;/select&gt;</B>
&lt;/p&gt;

&lt;p&gt;
  &lt;input type=&quot;<SPAN LANG="da-DK">reset</SPAN>&quot; value=&quot;Nulstil&quot;&gt;
  &lt;input type=&quot;<SPAN LANG="da-DK">submit</SPAN>&quot; name=&quot;<SPAN LANG="da-DK">indsendKnap</SPAN>&quot; value=&quot;Indsend data&quot;&gt;
  &lt;input type=&quot;image&quot; <SPAN LANG="da-DK">src</SPAN>=&quot;<SPAN LANG="da-DK">sun</SPAN>_<SPAN LANG="da-DK">java.png</SPAN>&quot; name=&quot;<SPAN LANG="da-DK">javaKnap</SPAN>&quot; value=&quot;kaffekop&quot;&gt;
&lt;/p&gt;

&lt;/form&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE>

<P CLASS="western" ALIGN=CENTER><IMG SRC="bog4_html_m5a76102e.png" NAME="Grafik15" ALIGN=BOTTOM BORDER=0></P>

<H3 CLASS="western" STYLE="">3.2.5 <a name='afsn3.2.5'></a>Afl&aelig;se
alle parametre i en formular</H3>
<P CLASS="western">Det f&oslash;lgende afl&aelig;ser alle
parametrene i ovenst&aring;ende formular og <SPAN LANG="da-DK">udskriver</SPAN>
dem.</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>parametre3.jsp
 (JSTL-eksempel i <a href='kapitel6.jsp#afsn6.1.4'>afsnit 6.1.4</a>)</I></FONT></P>
<PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Parametre3&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;

&lt;p&gt;
Her er <SPAN LANG="da-DK">parameteren</SPAN> &quot;navn&quot;: &lt;%= request.getParameter(&quot;navn&quot;) %&gt;&lt;br&gt;
&lt;/p&gt;

&lt;p&gt;
Andre parametre:&lt;br&gt;
&lt;%
  <I>// <SPAN LANG="da-DK">udskriv</SPAN> alle parametrene</I>
  <SPAN LANG="da-DK">java.util.Enumeration</SPAN> <SPAN LANG="da-DK">enumeration</SPAN> = <SPAN LANG="da-DK">request.getParameterNames</SPAN>();
  <SPAN LANG="da-DK">while</SPAN> (<SPAN LANG="da-DK">enumeration.hasMoreElements</SPAN>()) {
    String parameternavn = (String)<SPAN LANG="da-DK">enumeration.nextElement</SPAN>();
    String parameterv&aelig;rdi = request.getParameter(parameternavn);
    out.println(parameternavn+&quot; med v&aelig;rdi: '&quot;+parameterv&aelig;rdi+&quot;'&lt;br&gt;&quot;);
  }
%&gt;
&lt;/p&gt;

&lt;p&gt;
<SPAN LANG="da-DK">Parameteren</SPAN> 'kan_spise' har flere v&aelig;rdier.&lt;br&gt;
De er:
&lt;%
  String[] v&aelig;rdier = <SPAN LANG="da-DK">request.getParameterValues</SPAN>(&quot;kan_spise&quot;);
  if (v&aelig;rdier != null) {<BR>    for (int i = 0; i &lt; <SPAN LANG="da-DK">v&aelig;rdier.length</SPAN>; i++)<BR>      out.println(v&aelig;rdier[i]);
  }<BR><IMG SRC="bog4_html_m17e34eb2.png" NAME="Grafik19" ALIGN=LEFT BORDER=0>%&gt;
&lt;/p&gt;

&lt;/body&gt;
&lt;/html&gt;</PRE>



<H3 CLASS="western">3.2.6 <a name='afsn3.2.6'></a>Videre l&aelig;sning</H3>
<P CLASS="western"><SPAN LANG="da-DK">For en grundigere gennemgang
af, hvilke forskellige felter, der kan findes i en formular, henvises
til f.eks. artiklen &quot;L&aelig;r at lave formularer&quot; p&aring;
</SPAN><A CLASS="western" HREF="http://html.dk/artikler/00011"><SPAN LANG="da-DK">http://html.dk/artikler/00011</SPAN></A><SPAN LANG="da-DK">.</SPAN></P>

<H3 CLASS="western">3.2.7 <a name='afsn3.2.7'></a>Opgaver</H3>
<OL>
  <LI><P CLASS="western">Lav en valutaberegnings-webside, der kan
  omregne fra US dollar til euro.</P>
  <LI><P CLASS="western">Udvid  valutaberegnings-websiden med en
  valgliste, s&aring; brugeren kan v&aelig;lge mellem flere valutaer</P>
  <LI><P CLASS="western">Lav en tekstanalyse-webside med et
  indtastningsfelt (textarea), hvor brugeren kan indtaste (eller
  inds&aelig;tte fra et andet dokument) en tekst, som websiden
  derefter behandler. <BR>Websiden kan <SPAN LANG="da-DK">f.eks.</SPAN>
  oplyse antallet af tegn i teksten og hvordan strengen ser ud skrevet
  bagfra (vink.: Brug <SPAN LANG="da-DK">new</SPAN>
  <SPAN LANG="da-DK">StringBuffer</SPAN>(teksten).<SPAN LANG="da-DK">reverse</SPAN>().<SPAN LANG="da-DK">toString</SPAN>()
  for at vende strengen om).</P>
  <LI><P CLASS="western">Udvid tekstanalyse-websiden, s&aring;
  brugeren kan taste en ordl&aelig;ngde ind, hvorefter siden t&aelig;ller
  antallet af ord med netop den l&aelig;ngde.</P>
</OL>
<H2 CLASS="western" STYLE="">3.3 <a name='afsn3.3'></a>Appendiks:
Typer af formularfelter</SPAN></H2>
<P CLASS="western">Her er en oversigt over de mest almindelige typer
af formularfelter:</P>
<TABLE BORDER=1 BORDERCOLOR="#000000" CELLPADDING=4 CELLSPACING=0>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P CLASS="western">HTML-kode</P>
      </TH>
      <TH>
        <P CLASS="western">Betydning</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;text&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Indtastningsfelt (&eacute;n linje)</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;password&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Kodefelt - indtastningsfelt, hvor der vises
        stjerner i stedet for den indtastede tekst</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;hidden&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Skjult felt. Vises ikke for brugeren, men har
        alligevel en v&aelig;rdi, se <a href='kapitel3.jsp#afsn3.6.2'>afsnit 3.6.2</a>, Skjulte felter i formularer.</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;textarea&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Tekstomr&aring;de p&aring; flere linjer</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;checkbox&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Afkrydsningsfelt</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;radio&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Radioknapper, d.v.s. afkrydsningsfelter, der
        gensidigt udelukker hinanden (de skal have samme name-attribut)</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;select&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Valgliste. Hver mulighed markeres med en
        &lt;option&gt;-indgang. Med size-attributten kan man lade flere
        elementer i listen blive vist p&aring; en gang. Svarer
        funktionelt til et s&aelig;t radioknapper). Med
        multiple-attributten kan flere indgange v&aelig;lges (s&aring;
        den funktionelt svarer til et s&aelig;t afkrydsningsfelter).</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;image&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Billede - trykker man p&aring; billedet
        indsendes formularen med x- og y-koordinater p&aring;, hvor p&aring;
        billedet brugeren trykkede 
        </P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;submit&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Indsendingsknap - trykker man p&aring; knappen
        indsendes formularen med knappens navn og v&aelig;rdi som
        parameter. 
        </P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;reset&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Nulstiller formularen til dens udgangspunkt,
        d.v.s. annullerer alle brugerens &aelig;ndringer.</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>


<H2 CLASS="western" STYLE="">3.4 <a name='afsn3.4'></a>Test dig
selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.4">
  <input type='checkbox' name='vis' value='3.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">3.5 <a name='afsn3.5'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.5">
  <input type='checkbox' name='vis' value='3.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western" STYLE="">3.6 <a name='afsn3.6'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.6">
  <input type='checkbox' name='vis' value='3.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.6.1 <a name='afsn3.6.1'></a>Indkode data i en URL (URL-indkodning)</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.6.1">
  <input type='checkbox' name='vis' value='3.6.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.6.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.6.2 <a name='afsn3.6.2'></a><SPAN LANG="da-DK">Skjulte</SPAN> felter i
formularer</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.6.2">
  <input type='checkbox' name='vis' value='3.6.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.6.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.6.3 <a name='afsn3.6.3'></a>Bruge skjulte felter til at etablere et
forl&oslash;b</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.6.3">
  <input type='checkbox' name='vis' value='3.6.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.6.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.6.4 <a name='afsn3.6.4'></a>Skjule parametrene (POST-metoden)</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.6.4">
  <input type='checkbox' name='vis' value='3.6.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.6.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.6.5 <a name='afsn3.6.5'></a>Cookier</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.6.5">
  <input type='checkbox' name='vis' value='3.6.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.6.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.6.6 <a name='afsn3.6.6'></a>S&aelig;tte cookier</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.6.6">
  <input type='checkbox' name='vis' value='3.6.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.6.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.6.7 <a name='afsn3.6.7'></a>Afl&aelig;se cookier</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.6.7">
  <input type='checkbox' name='vis' value='3.6.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.6.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<H2 CLASS="western" STYLE="">3.7 <a name='afsn3.7'></a>Avanceret:
HTTP-protokollen</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.7">
  <input type='checkbox' name='vis' value='3.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.7.1 <a name='afsn3.7.1'></a>Eksempel p&aring; kommunikation</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.7.1">
  <input type='checkbox' name='vis' value='3.7.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.7.2 <a name='afsn3.7.2'></a>Formulardata med GET-metoden</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.7.2">
  <input type='checkbox' name='vis' value='3.7.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.7.3 <a name='afsn3.7.3'></a>Formulardata med POST-metoden</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.7.3">
  <input type='checkbox' name='vis' value='3.7.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.7.4 <a name='afsn3.7.4'></a>Cookier</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.7.4">
  <input type='checkbox' name='vis' value='3.7.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.7.5 <a name='afsn3.7.5'></a>&Oslash;velse</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.7.5">
  <input type='checkbox' name='vis' value='3.7.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.7.6 <a name='afsn3.7.6'></a>Sende mere data til klienten l&oslash;bende</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.7.6">
  <input type='checkbox' name='vis' value='3.7.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.7.7 <a name='afsn3.7.7'></a>Eksempel: Syvtabellen langsomt</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.7.7">
  <input type='checkbox' name='vis' value='3.7.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">3.7.8 <a name='afsn3.7.8'></a>Eksempel: F&oslash;lge med i serverens
logfil</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel3.jsp#afsn3.7.8">
  <input type='checkbox' name='vis' value='3.7.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='3.7.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Da
  angiver man blot en absolut URL, f.eks.: <BR>&lt;form
  action=&quot;http://minesider.dk/parametre2.jsp&quot;&gt;</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Og
  derved kan man s&aring; ikke mere foretage omdirigeringer, j.v.f.
  <a href='kapitel3.jsp#afsn3.7'>afsnit 3.7</a> og <a href='kapitel4.jsp#afsn4.3'>afsnit 4.3</a>.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel4.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
